﻿using Cobian.Honeypot.Classes;
using Cobian.Honeypot.Enumerations;


/***********************************************************************************
*                                                                                  *
*  Copyright (C) 2026 Luis Cobian, CobianSoft.                                     *
*  All rights reserved.                                                            *
*                                                                                  *
*  http://www.cobiansoft.com                                                       *
*  cobian@cobiansoft.com                                                           * 
*                                                                                  *
*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR      *
*  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,        *
*  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE     *
*  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER          *
*  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,   *
*  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN       *
*  THE SOFTWARE.                                                                   *
*                                                                                  *
***********************************************************************************/

using Cobian.Honeypot.Interfaces;

namespace Cobian.Honeypot.Plugins
{
    /// <summary>
    /// This is the main class of the plugin
    /// </summary>
    public class ChPlugin : IPlugin
    {
        private ISettings? settings;
        private ILogger? logger;
        private ITranslator? translator;

        /// <summary>
        /// This is the supported OS
        /// </summary>
        public static OsTypes SupportedOS => OsTypes.Linux | OsTypes.Windows | OsTypes.MacOS;

        /// <summary>
        /// The name of the plugin
        /// </summary>
        public string PluginName => Constants.PluginName;

        /// <summary>
        /// The author
        /// </summary>
        public string PluginAuthor => Custom.AuthorLong;

        /// <summary>
        /// The version of the plugin
        /// </summary>
        public string PluginVersion => Constants.PluginVersion;

        /// <summary>
        /// The mail of the author
        /// </summary>
        public string PluginContact => Custom.Contact;

        /// <summary>
        /// The web site
        /// </summary>
        public string? PluginWeb => Custom.ProgramWebSite;

        /// <summary>
        /// Some description
        /// </summary>
        public string PluginDescription => Constants.PluginDescription;

        /// <summary>
        /// The id of the plugin
        /// </summary>
        public string PluginId => Constants.PluginId;

        /// <summary>
        /// Do nothing
        /// </summary>
        /// <param name="info">A connection info</param>
        /// <returns>Normally true if everything was OK, false if some error occurred. </returns>
        public async Task<bool> ActionAsync(ConnectionInfo info)
        {
            await Task.Delay(Constants.DelayMs).ConfigureAwait(false);

            return true;
        }

        /// <summary>
        /// Call this before using ActionAsync
        /// </summary>
        /// <param name="settings">Some settings</param>
        /// <param name="translator">Some translator</param>
        /// <param name="logger">Some logger</param>
        public void Initialize(ISettings? settings, ITranslator? translator, ILogger? logger)
        {
            this.settings = settings;
            this.translator = translator;
            this.logger = logger;
        }

        /// <summary>
        /// Clean up if needed
        /// </summary>
        public void CleanUp()
        {
            settings = null;
            translator = null;
            logger = null;
        }

        /// <summary>
        /// If the plugin have settings, returns its settings
        /// </summary>
        /// <returns>The settings or null</returns>
        public ISettings? GetPluginSettings()
        {
            return null;
        }

        /// <summary>
        /// Set and save the settings
        /// </summary>
        /// <param name="settings">The settings to save</param>
        /// <param name="errorMessage">If an error occurred, then this is the error message</param>
        public bool SetPluginSettings(string? settings, out string? errorMessage)
        {
            errorMessage = null;
            return true;
        }
    }
}
